<?php
if (current_user_can('manage_options')) {
  if (isset($_POST['submit']) && check_admin_referer( 'shuoshuo_nonce', 'shuoshuo_nonce_field' )) {
    $shuoshuo_content = sanitize_textarea_field($_POST['shuoshuo_content']);
    $current_user = wp_get_current_user();
    $post_data = array(
      'post_content' => $shuoshuo_content,
      'post_type' => 'shuoshuo',
      'post_status' => 'publish',
      'post_author' => $current_user->ID
    );
    $post_id = wp_insert_post($post_data);
    if ($post_id) {
      echo '<p>您的说说已发布！</p>';
    }
    // 重定向到当前页面，以避免表单重复提交
    wp_redirect( get_permalink() );
    exit;
  }
}
?>


<?php 
/*
Template Name: 发表说说
*/
query_posts("post_type=shuoshuo&post_status=publish&posts_per_page=-1");
?>

<?php get_header(); ?>
<?php get_sidebar(); ?>


<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">
<?php
if (current_user_can('manage_options')) { // 检查当前用户是否为管理员
?>
<div id="post_shuoshuo" class="card shadow-sm logged">
	<div class="card-body">
		<h2 class="post-shuoshuo-title">
		<i class="fa fa-commenting"></i>
		<span class="btn-inner--text hide-on-comment-editing" style="margin-right: 0;">说句话吧</span>
		</h2>
		
		<form id="shuoshuo-form" method="post" action="">
			<div class="row">
				<div class="col-md-12">
					<textarea id="shuoshuo-content" class="form-control form-control-alternative fixed-height" placeholder="在做什么？有没有空？" name="shuoshuo_content" style="height: 41px;"></textarea>
					<?php wp_nonce_field( 'shuoshuo_nonce', 'shuoshuo_nonce_field' ); ?>
				</div>
			</div>
			
			<div class="row" style="margin-top: 5px; margin-bottom: 10px;">
			
				<div class="col-md-12">
					
					<button type="submit" name="submit" class="btn btn-icon btn-primary comment-btn pull-right mr-0">
						<span class="btn-inner--icon hide-on-comment-not-editing"><i class="fa fa-send"></i></span>
						<span class="btn-inner--text hide-on-comment-editing" style="margin-right: 0;">发送</span>
					</button>
				</div>
			</div>
		</form>
	</div>
</div>
<?php
}
?>



<style>
	#primary {
    position: absolute;
	left: 0;
	right: 0;
	margin: auto;
	max-width: 800px;
}
.post-shuoshuo-title {
	font-size: 0px;
}
.post-shuoshuo-title:after {
	content: '说句话吧';
	font-size: 20px;
}
.post-shuoshuo-title i {
	font-size: 20px;
	margin-right: 10px;
}
textarea.fixed-height {
  height: 200px;
  resize: none;
}

</style>
<div style="margin-top: 30px; margin-bottom: 30px;"></div>
<?php get_footer(); ?>
